#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24106);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-0903", "CVE-2006-1518");
 
 name["english"] = "Fedora Core 4 2006-554: mysql";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-554 (mysql).

MySQL is a multi-user, multi-threaded SQL database server. MySQL is a
client/server implementation consisting of a server daemon (mysqld)
and many different client programs and libraries. The base package
contains the MySQL client programs, the client shared libraries, and
generic MySQL files.

Update Information:

4.1.19 fixes several moderate-severity security issues: see CVE-2006-0903 CVE-2
006-1516
CVE-2006-1517 CVE-2006-1518, also our bugs 180467 180639 182025 183261 190866 1
90868
190870



Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mysql package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mysql-4.1.19-1.FC4.1", release:"FC4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"mysql-", release:"FC4") )
{
 set_kb_item(name:"CVE-2006-0903", value:TRUE);
 set_kb_item(name:"CVE-2006-1518", value:TRUE);
}
