#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24137);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-2198", "CVE-2006-2199", "CVE-2006-3117");
 
 name["english"] = "Fedora Core 4 2006-764: openoffice.org";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-764 (openoffice.org).

OpenOffice.org is an Open Source, community-developed, multi-platform
office productivity suite.  It includes the key desktop applications,
such as a word processor, spreadsheet, presentation manager, formula
editor and drawing program, with a user interface and feature set
similar to other office suites.  Sophisticated and flexible,
OpenOffice.org also works transparently with a variety of file
formats, including Microsoft Office.

Usage: Simply type 'ooffice' to run OpenOffice.org or select the
requested component (Writer, Calc, Draw, Impress, etc.) from your
desktop menu. On first start a few files will be installed in the
user's home, if necessary.

The OpenOffice.org team hopes you enjoy working with OpenOffice.org!

Note: Non-.vor templates covered under the GPL license.

Update Information:

- CVE-2006-2198 macro security
- CVE-2006-2199 java applets
- CVE-2006-3117 corrupt file format
more details at
[8]http://www.openoffice.org/security/bulletin-20060629.html


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openoffice.org package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"openoffice.org-2.0.1.1-7.1", prefix:"openoffice.org-", release:"FC4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"openoffice.org-", release:"FC4") )
{
 set_kb_item(name:"CVE-2006-2198", value:TRUE);
 set_kb_item(name:"CVE-2006-2199", value:TRUE);
 set_kb_item(name:"CVE-2006-3117", value:TRUE);
}
