#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24141);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-2842", "CVE-2006-3174");
 
 name["english"] = "Fedora Core 5 2006-788: squirrelmail";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-788 (squirrelmail).

SquirrelMail is a standards-based webmail package written in PHP4. It
includes built-in pure PHP support for the IMAP and SMTP protocols, and
all pages render in pure HTML 4.0 (with no Javascript) for maximum
compatibility across browsers.  It has very few requirements and is very
easy to configure and install. SquirrelMail has all the functionality
you would want from an email client, including strong MIME support,
address books, and folder manipulation.

Update Information:

Many fixes here.  Please report any regressions to Red Hat
Bugzilla.

- 1.4.7 with CVE-2006-3174 (#197369)
- Move sqspell_config.php to /etc and mark it
%%config(noreplace) (#192236)
- Reduce patch for body text (#194457)
- Better JP translation for 'Check mail' (#196117)
- Japanese zenkaku subject conversion      (#196017)
- Japanese MSIE garbled download ugly hack (#195639)
- Japanese multibyte attachment view text  (#195452)
- Japanese multibyte attachment body text  (#194457)
- Do not convert Japanese Help to UTF-8    (#194599)


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the squirrelmail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"squirrelmail-1.4.7-2.fc5", prefix:"squirrelmail-", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"squirrelmail-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-2842", value:TRUE);
 set_kb_item(name:"CVE-2006-3174", value:TRUE);
}
