#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24161);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-3747");
 
 name["english"] = "Fedora Core 4 2006-862: httpd";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-862 (httpd).

The Apache HTTP Server is a powerful, full-featured, efficient, and
freely-available Web server. The Apache HTTP Server is also the
most popular Web server on the Internet.

Update Information:

This update fixes a security issue in the mod_rewrite module.

Mark Dowd of McAfee Avert Labs reported an off-by-one
security problem in the LDAP scheme handling of the
mod_rewrite module. Where RewriteEngine was enabled, and for
certain RewriteRules, this could lead to a pointer being
written out of bounds.   (CVE-2006-3747)

The ability to exploit this issue is dependent on the stack
layout for a particular compiled version of mod_rewrite.
The Fedora project has analyzed Fedora Core 4 and 5 binaries
and determined that these distributions are vulnerable to
this issue.  However this flaw does not affect a default
installation of Fedora Core; users who do not use, or have
not enabled, the Rewrite module are not affected by this
issue.


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the httpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"httpd-2.0.54-10.4", release:"FC4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-devel-2.0.54-10.4", release:"FC4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mod_ssl-2.0.54-10.4", release:"FC4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"httpd-", release:"FC4") )
{
 set_kb_item(name:"CVE-2006-3747", value:TRUE);
}
