#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24165);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-3459", "CVE-2006-3461", "CVE-2006-3463", "CVE-2006-3465");
 
 name["english"] = "Fedora Core 5 2006-877: libtiff";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-877 (libtiff).

The libtiff package contains a library of functions for manipulating
TIFF (Tagged Image File Format) image format files.  TIFF is a widely
used file format for bitmapped images.  TIFF files usually end in the
.tif extension and they are often quite large.

The libtiff package should be installed if you need to manipulate TIFF
format image files.

Update Information:

The libtiff package contains a library of functions for
manipulating TIFF (Tagged Image File Format) files.

Tavis Ormandy of Google discovered a number of flaws in
libtiff during a security audit. An attacker could create a
carefully crafted TIFF file in such a way that it was
possible to cause an application linked with libtiff to
crash or possibly execute arbitrary code. (CVE-2006-3459,
CVE-2006-3460, CVE-2006-3461, CVE-2006-3462, CVE-2006-3463,
CVE-2006-3464, CVE-2006-3465)

All users are advised to upgrade to these updated packages,
which contain backported fixes for these issues.


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libtiff package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libtiff-devel-3.7.4-8", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libtiff-3.7.4-8", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"libtiff-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-3459", value:TRUE);
 set_kb_item(name:"CVE-2006-3461", value:TRUE);
 set_kb_item(name:"CVE-2006-3463", value:TRUE);
 set_kb_item(name:"CVE-2006-3465", value:TRUE);
}
