#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24173);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4331", "CVE-2006-4332", "CVE-2006-4333");
 
 name["english"] = "Fedora Core 5 2006-936: wireshark";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-936 (wireshark).

Wireshark is a network traffic analyzer for Unix-ish operating systems.

This package lays base for libpcap, a packet capture and filtering
library, contains command-line utilities, contains plugins and
documentation for wireshark. A graphical user interface is packaged
separately to GTK+ package.

Update Information:

CVE-2006-4330 Wireshark security issues (CVE-2006-4333
CVE-2006-4332 CVE-2006-4331)


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wireshark package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"wireshark-0.99.3-fc5.1", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"wireshark-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-4331", value:TRUE);
 set_kb_item(name:"CVE-2006-4332", value:TRUE);
 set_kb_item(name:"CVE-2006-4333", value:TRUE);
}
