#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24182);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4340");
 
 name["english"] = "Fedora Core 5 2006-979: nss";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2006-979 (nss).

Network Security Services (NSS) is a set of libraries designed to
support cross-platform development of security-enabled client and
server applications. Applications built with NSS can support SSL v2
and v3, TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME, X.509
v3 certificates, and other security standards.

Update Information:

Network Security Services (NSS) is a set of libraries
designed to support cross-platform development of
security-enabled client and server applications.
Applications built with NSS can support SSL v2 and v3, TLS,
PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME, X.509 v3
certificates, and other security standards.

Daniel Bleichenbacher recently described an implementation
error in RSA signature verification. For RSA keys with
exponent 3 it is possible for an attacker to forge a
signature that which would be incorrectly verified by the
NSS library. (CVE-2006-4340)

All users of NSS, which includes users of Firefox,
Thunderbird, Seamonkey, and other mozilla.org products, are
recommended to update to this package, which contains NSS
version 3.11.3 which is not vulnerable to this issue.


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the nss package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"nss-3.11.3-0.5.fc5", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"nss-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-4340", value:TRUE);
}
