#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24185);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5461", "CVE-2006-6870");
 
 name["english"] = "Fedora Core 5 2007-018: avahi";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-018 (avahi).

Avahi is a system which facilitates service discovery on
a local network -- this means that you can plug your laptop or
computer into a network and instantly be able to view other people who
you can chat with, find printers to print to or find files being
shared. This kind of technology is already found in MacOS X (branded
'Rendezvous', 'Bonjour' and sometimes 'ZeroConf') and is very
convenient.

Update Information:

avahi-0.6.11-3.fc5 should fix CVE-2006-6870 - the
consume_labels function in avahi-core/dns.c in Avahi before
0.6.16 allows remote attackers to cause a denial of service
(infinite loop) via a crafted compressed DNS response with a
label that points to itself.


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the avahi package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"avahi-0.6.11-3.fc5", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"avahi-glib-0.6.11-3.fc5", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"avahi-qt3-0.6.11-3.fc5", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"avahi-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-5461", value:TRUE);
 set_kb_item(name:"CVE-2006-6870", value:TRUE);
}
