#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0185 (wpa_supplicant).

wpa_supplicant is a WPA Supplicant for Linux, BSD and Windows with support
for WPA and WPA2 (IEEE 802.11i / RSN). Supplicant is the IEEE 802.1X/WPA
component that is used in the client stations. It implements key negotiation
with a WPA Authenticator and it controls the roaming and IEEE 802.11
authentication/association of the wlan driver.

-
Update Information:

A buffer overflow flaw was found in the debugging code of Fedora's version of w
pa_supplicant.  This can be triggered by those using NetworkManager.

It is recommended that users of wpa_supplicant or NetworkManager update to this
package (and the accompanying NetworkManager packages) which removes the affec
ted debug code.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27654);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-0185: wpa_supplicant";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wpa_supplicant package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"wpa_supplicant-0.5.7-3.fc7", prefix:"wpa_supplicant-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
