#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0249 (php-pear-DB).

DB is a database abstraction layer providing:
* an OO-style query API
* portability features that make programs written for one DBMS work with
other DBMS's
* a DSN (data source name) format for specifying database servers
* prepare/execute (bind) emulation for databases that don't support it natively
* a result object for each query response
* portable error codes
* sequence emulation
* sequential and non-sequential row fetching as well as bulk fetching
* formats fetched rows as associative arrays, ordered arrays or objects
* row limit support
* transactions support
* table information interface
* DocBook and phpDocumentor API documentation

DB layers itself on top of PHP's existing database extensions.

-
Update Information:

1.7.11 : fbsql:

Update information :

* Fixed commit and rollback to specify the handle to be used.

1.7.10 : mysqli:


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27656);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2006-2313", "CVE-2006-2314");
 
 name["english"] = "Fedora Core 7 2007-0249: php-pear-DB";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php-pear-DB package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"php-pear-DB-1.7.11-1.fc7", prefix:"php-pear-DB-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"php-pear-DB-", release:"FC7") )
{
 set_kb_item(name:"CVE-2006-2313", value:TRUE);
 set_kb_item(name:"CVE-2006-2314", value:TRUE);
}
