#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0409 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

-
Update Information:

Rebase to upstream 2.6.21.5, including several security fixes (See CVEs for det
ails).

Upstream changelog:
[8]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.21.3
[9]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.21.4
[10]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.21.5

Fedora specific changes detailed below:



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27664);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-2451", "CVE-2007-2453", "CVE-2007-2876");
 
 name["english"] = "Fedora Core 7 2007-0409: kernel";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"kernel-2.6.21-1.3228.fc7", prefix:"kernel-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kernel-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-2451", value:TRUE);
 set_kb_item(name:"CVE-2007-2453", value:TRUE);
 set_kb_item(name:"CVE-2007-2876", value:TRUE);
}
