#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24229);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "Fedora Core 6 2007-058: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-058 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

Update Information:

This is a large rebase to the latest upstream stable kernel
(2.6.19.2)
Complete changelogs available at
www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.19
www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.19.1
www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.19.2

This update also introduces 'kernel-debug', a variant with
additional debugging options enabled. These kernels may run
with lower performance and increased memory overhead than
the non-debug variants.


Solution : Get the newest Fedora Updates
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"kernel-2.6.19-1.2895.fc6", prefix:"kernel-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
