#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0724 (c-ares).

c-ares is a C library that performs DNS requests and name resolves
asynchronously. c-ares is a fork of the library named 'ares', written
by Greg Hudson at MIT.

-
Update Information:

There is a vulnerability in c-ares < 1.4.0, caused by predictable DNS 'Transact
ion ID' field in DNS queries and can be exploited to poison the DNS cache of an
application using the library if a valid ID is guessed.

[8]http://www.vuxml.org/freebsd/70ae62b0-16b0-11dc-b803-0016179b2dd5.html



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27676);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3152", "CVE-2007-3153");
 
 name["english"] = "Fedora Core 7 2007-0724: c-ares";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the c-ares package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"c-ares-1.4.0-1.fc7", prefix:"c-ares-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"c-ares-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3152", value:TRUE);
 set_kb_item(name:"CVE-2007-3153", value:TRUE);
}
