#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0756 (HelixPlayer).

Helix Player is an open-source media player built in the Helix
Community for consumers. Built using GTK, it plays open source formats,
like Ogg Vorbis and Theora using the powerful Helix DNA Client Media
Engine.

-
Update Information:

A buffer overflow flaw was discovered in the way RealPlayer and HelixPlayer han
dle the wallclock variable in Synchronized Multimedia Integration Language (SMI
L) files.

More information regarding this flaw can be found here:
[8]http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=547


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27679);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3410");
 
 name["english"] = "Fedora Core 7 2007-0756: HelixPlayer";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the HelixPlayer package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"HelixPlayer-1.0.7-6.fc7", prefix:"HelixPlayer-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"HelixPlayer-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3410", value:TRUE);
}
