#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0894 (wordpress).

Wordpress is an online publishing / weblog package that makes it very easy,
almost trivial, to get information out to people on the web.

-
ChangeLog:


Update information :

* Wed Jul  4 2007 John Berninger <john at ncphotography dot com> - 2.2.1-1
- update to upstream 2.2.1 to fix various vulnerabilities


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27684);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-0894: wordpress";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wordpress package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"wordpress-2.2.1-1.fc7", prefix:"wordpress-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
