#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-0982 (wireshark).

Wireshark is a network traffic analyzer for Unix-ish operating systems.

This package lays base for libpcap, a packet capture and filtering
library, contains command-line utilities, contains plugins and
documentation for wireshark. A graphical user interface is packaged
separately to GTK+ package.

-
Update Information:

- multiple security issues fixed
- Wireshark could crash when dissecting an HTTP chunked response
- Wireshark could crash while reading iSeries capture files
- Wireshark could exhaust system memory while reading a
malformed DCP ETSI packet
- Wireshark could loop excessively while reading a malformed SSL packet


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27686);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-0982: wireshark";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wireshark package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"wireshark-0.99.6-1.fc7", prefix:"wireshark-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
