#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1155 (epiphany-extensions).

Epiphany Extensions is a collection of extensions for Epiphany, the
GNOME web browser.

-
Update Information:

Updated Firefox packages that fix several security bugs are now available for F
edora 7.

Users of epiphany-extensions are advised to upgrade to this errata package, whi
ch has been rebuilt against the updated Firefox package.




Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27700);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3089", "CVE-2007-3656", "CVE-2007-3734", "CVE-2007-3735", "CVE-2007-3736", "CVE-2007-3737", "CVE-2007-3738");
 
 name["english"] = "Fedora Core 7 2007-1155: epiphany-extensions";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the epiphany-extensions package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"epiphany-extensions-2.18.3-2", prefix:"epiphany-extensions-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"epiphany-extensions-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3089", value:TRUE);
 set_kb_item(name:"CVE-2007-3656", value:TRUE);
 set_kb_item(name:"CVE-2007-3734", value:TRUE);
 set_kb_item(name:"CVE-2007-3735", value:TRUE);
 set_kb_item(name:"CVE-2007-3736", value:TRUE);
 set_kb_item(name:"CVE-2007-3737", value:TRUE);
 set_kb_item(name:"CVE-2007-3738", value:TRUE);
}
