#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1160 (centericq).

Centericq is a text mode menu- and window-driven IM interface that supports the
ICQ2000, Yahoo!, AIM, MSN, IRC and Jabber protocols.

-
ChangeLog:


Update information :

* Thu Jul 19 2007 Andreas Bierfert <andreas.bierfert[AT]lowlatency.de>
- 4.21.0-13
- fix CVE-2007-3713 multiple buffer overflows (#247979) with help from
Lubomir Kundrak


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27704);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3713");
 
 name["english"] = "Fedora Core 7 2007-1160: centericq";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the centericq package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"centericq-4.21.0-13.fc7", prefix:"centericq-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"centericq-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3713", value:TRUE);
}
