#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1180 (thunderbird).

Mozilla Thunderbird is a standalone mail and newsgroup client.

-
Update Information:

Mozilla Thunderbird is a standalone mail and newsgroup client.

Several flaws were found in the way Thunderbird processed certain malformed Jav
aScript code. A malicious HTML email message containing JavaScript code could c
ause Thunderbird to crash or potentially execute arbitrary code as the user run
ning Thunderbird. JavaScript support is disabled by default in Thunderbird; the
se issues are not exploitable unless the user has enabled JavaScript. (CVE-2007
-3089, CVE-2007-3734, CVE-2007-3735, CVE-2007-3736, CVE-2007-3737, CVE-2007-373
8)

Users of Thunderbird are advised to upgrade to these erratum packages, which co
ntain patches that correct these issues.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27705);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3089", "CVE-2007-3734", "CVE-2007-3735", "CVE-2007-3736", "CVE-2007-3737", "CVE-2007-3738");
 
 name["english"] = "Fedora Core 7 2007-1180: thunderbird";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the thunderbird package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"thunderbird-2.0.0.5-1.fc7", prefix:"thunderbird-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"thunderbird-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3089", value:TRUE);
 set_kb_item(name:"CVE-2007-3734", value:TRUE);
 set_kb_item(name:"CVE-2007-3735", value:TRUE);
 set_kb_item(name:"CVE-2007-3736", value:TRUE);
 set_kb_item(name:"CVE-2007-3737", value:TRUE);
 set_kb_item(name:"CVE-2007-3738", value:TRUE);
}
