#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1447 (balsa).

Balsa is a GNOME email client which supports mbox, maildir, and mh
local mailboxes, and IMAP4 and POP3 remote mailboxes. Email can be
sent via sendmail or SMTP. Optional multithreading support allows for
non-intrusive retrieval and sending of mail. A finished GUI similar to
that of the Eudora email client supports viewing images inline, saving
message parts, viewing headers, adding attachments, moving messages,
and printing messages.

-
Update Information:

Balsa is not really listed in the list but it also lacked the verification of t
he server challenge.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27718);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1558");
 
 name["english"] = "Fedora Core 7 2007-1447: balsa";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the balsa package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"balsa-2.3.17-2.fc7", prefix:"balsa-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"balsa-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
}
