#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-1765 (libvorbis).

Ogg Vorbis is a fully open, non-proprietary, patent-and royalty-free,
general-purpose compressed audio format for audio and music at fixed
and variable bitrates from 16 to 128 kbps/channel.

The libvorbis package contains runtime libraries for use in programs
that support Ogg Voribs.

-
Update Information:

Multiple security flaws were found in libvorbis.  This updated package fixes th
em all.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27731);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3106", "CVE-2007-4029", "CVE-2007-4065", "CVE-2007-4066");
 
 name["english"] = "Fedora Core 7 2007-1765: libvorbis";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libvorbis package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"libvorbis-1.1.2-3.fc7", prefix:"libvorbis-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"libvorbis-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3106", value:TRUE);
 set_kb_item(name:"CVE-2007-4029", value:TRUE);
 set_kb_item(name:"CVE-2007-4065", value:TRUE);
 set_kb_item(name:"CVE-2007-4066", value:TRUE);
}
