#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2017 (krb5).

Kerberos V5 is a trusted-third-party network authentication system,
which can improve your network's security by eliminating the insecure
practice of cleartext passwords.

-
Update Information:

This update incorporates fixes for a stack overflow in the rpcsec_gss implement
ation in libgssrpc (CVE-2007-3999) and a potential write through an uninitializ
ed pointer in kadmind (CVE-2007-4000).


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27744);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1216", "CVE-2007-2443", "CVE-2007-2798", "CVE-2007-3999", "CVE-2007-4000");
 
 name["english"] = "Fedora Core 7 2007-2017: krb5";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the krb5 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"krb5-1.6.1-3.fc7", prefix:"krb5-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"krb5-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-1216", value:TRUE);
 set_kb_item(name:"CVE-2007-2443", value:TRUE);
 set_kb_item(name:"CVE-2007-2798", value:TRUE);
 set_kb_item(name:"CVE-2007-3999", value:TRUE);
 set_kb_item(name:"CVE-2007-4000", value:TRUE);
}
