#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-216 (wireshark).

Wireshark is a network traffic analyzer for Unix-ish operating systems.

This package lays base for libpcap, a packet capture and filtering
library, contains command-line utilities, contains plugins and
documentation for wireshark. A graphical user interface is packaged
separately to GTK+ package.

Update Information:

- multiple security issues fixed (#227140)
- CVE-2007-0459 - The TCP dissector could hang or crash
while reassembling HTTP packets
- CVE-2007-0459 - The HTTP dissector could crash.
- CVE-2007-0457 - On some systems, the IEEE 802.11 dissector
could crash.
- CVE-2007-0456 - On some systems, the LLT dissector could
crash.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24304);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0456", "CVE-2007-0457", "CVE-2007-0459");
 
 name["english"] = "Fedora Core 6 2007-216: wireshark";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wireshark package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"wireshark-0.99.5-1.fc6", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"wireshark-", release:"FC6") )
{
 set_kb_item(name:"CVE-2007-0456", value:TRUE);
 set_kb_item(name:"CVE-2007-0457", value:TRUE);
 set_kb_item(name:"CVE-2007-0459", value:TRUE);
}
