#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2199 (cacti).

Cacti is a complete frontend to RRDTool. It stores all of the
necessary information to create graphs and populate them with
data in a MySQL database. The frontend is completely PHP
driven. Along with being able to maintain graphs, data
sources, and round robin archives in a database, Cacti also
handles the data gathering. There is SNMP support for those
used to creating traffic graphs with MRTG.

-
ChangeLog:


Update information :

* Fri Sep 14 2007 Mike McGrath <mmcgrath redhat com> - 0.8.6j-8
- Fix for CVE-2007-3112 bz#243592


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27757);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3112", "CVE-2007-3113");
 
 name["english"] = "Fedora Core 7 2007-2199: cacti";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cacti package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"cacti-0.8.6j-8.fc7", prefix:"cacti-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"cacti-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3112", value:TRUE);
 set_kb_item(name:"CVE-2007-3113", value:TRUE);
}
