#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2214 (httpd).

The Apache HTTP Server is a powerful, efficient, and extensible
web server.

-
Update Information:

This update includes the latest stable release of the Apache HTTP Server.

A flaw was found in the Apache HTTP Server mod_proxy module. On sites where a r
everse proxy is configured, a remote attacker could send a carefully crafted re
quest that would cause the Apache child process handling that request to crash.
On sites where a forward proxy is configured, an attacker could cause a simila
r crash if a user could be persuaded to visit a
malicious site using the proxy. This could lead to a denial of service if using
a threaded Multi-Processing Module. (CVE-2007-3847)

A flaw was found in the mod_autoindex module.  On sites where directory listing
s are used, and the AddDefaultCharset directive has been removed from the confi
guration, a cross-site-scripting attack may be possible against browsers which
do not correctly derive the response character set following the rules in RFC 2
616. (CVE-2007-4465)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27758);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2006-5752", "CVE-2007-1862", "CVE-2007-3304", "CVE-2007-3847", "CVE-2007-4465");
 
 name["english"] = "Fedora Core 7 2007-2214: httpd";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the httpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"httpd-2.2.6-1.fc7", prefix:"httpd-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"httpd-", release:"FC7") )
{
 set_kb_item(name:"CVE-2006-5752", value:TRUE);
 set_kb_item(name:"CVE-2007-1862", value:TRUE);
 set_kb_item(name:"CVE-2007-3304", value:TRUE);
 set_kb_item(name:"CVE-2007-3847", value:TRUE);
 set_kb_item(name:"CVE-2007-4465", value:TRUE);
}
