#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2224 (elinks).

Links is a text-based Web browser. Links does not display any images,
but it does support frames, tables and most other HTML tags. Links'
advantage over graphical browsers is its speed--Links starts and exits
quickly and swiftly displays Web pages.

-
Update Information:

Update done because of security issue in elinks 0.11.2 , in this update are inc
luded other changes done in devel branch meanwhile(license tags,open macro,lice
nse file missing,duplicate buildrequires).


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27761);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5034");
 
 name["english"] = "Fedora Core 7 2007-2224: elinks";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the elinks package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"elinks-0.11.3-1.fc7", prefix:"elinks-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"elinks-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5034", value:TRUE);
}
