#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-226 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

Update Information:

CVE-2006-0007:
The key serial number collision avoidance code in the
key_alloc_serial function in Linux kernel 2.6.9 up to 2.6.20
allows remote attackers to cause a denial of service (crash)
via vectors that trigger a null dereference, as originally
reported as 'spinlock CPU recursion.'

Update to linux kernel 2.6.19.3:
www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.19.3

Bugs fixed:
227802, 226885, 225046, 223431



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24349);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-0007", "CVE-2007-0006");
 
 name["english"] = "Fedora Core 6 2007-226: kernel";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"kernel-2.6.19-1.2911.fc6", prefix:"kernel-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kernel-", release:"FC6") )
{
 set_kb_item(name:"CVE-2006-0007", value:TRUE);
 set_kb_item(name:"CVE-2007-0006", value:TRUE);
}
