#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2270 (xen).

This package contains the Xen hypervisor and Xen tools, needed to
run virtual machines on x86 systems, together with the kernel-xen*
packages.  Information on how to use Xen can be found at the Xen
project pages.

Virtualisation can be used to run multiple versions or multiple
Linux distributions on one system, or to test untrusted applications
in a sandboxed environment.

-
Update Information:

Fixes a security flaw in pygrub handling of config files and a denial-of-servic
e case in ne2k NIC for QEMU.

Fixes the case of disappearing network cards in fully-virtualized guests. NB, i
t only fixes it for guests created after this errata is installed & XenD restar
ted. Any pre-existing guests may continue to have problems. To fix existing gue
sts, first ensure XenD has been restarted (service xend restart), then use virt
-manager/virsh to remove the network card, and then add it back. This will corr
ect the configuration stored in XenD permanently.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27763);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1321", "CVE-2007-4993");
 
 name["english"] = "Fedora Core 7 2007-2270: xen";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xen package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"xen-3.1.0-6.fc7", prefix:"xen-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"xen-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-1321", value:TRUE);
 set_kb_item(name:"CVE-2007-4993", value:TRUE);
}
