#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2298 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

-
Update Information:

Update to official Linux 2.6.22.6 (from 2.6.22.6-rc1):
[8]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.22.6

Update to Linux 2.6.22.7:
[9]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.22.7

- libata: add option to disable DMA on PATA devices
(libata.pata_dma, see kernel-parameters.txt for details)
- libata: fix DMA on ATAPI devices with it821x (#242229)
- libata: fix cable detection on pata_via
- fix vmware's broken SCSI device emulation (#241935)
- fix init of huawei 220 modem (#253096)
- LVM: fix hang and lockups during snapshot (#269541)
- net: fix oops with zero-length packet
- USB: three trivial fixes
- futex: fix compat list traversal
- CFS scheduler update
- utrace update (#248532, #267161, #284311)
- wireless driver update



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27765);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4573");
 
 name["english"] = "Fedora Core 7 2007-2298: kernel";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"kernel-2.6.22.7-85.fc7", prefix:"kernel-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kernel-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-4573", value:TRUE);
}
