#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2343 (t1lib).

T1lib is a rasterizer library for Adobe Type 1 Fonts. It supports
rotation and transformation, kerning underlining and antialiasing. It
does not depend on X11, but does provides some special functions for
X11.

AFM-files can be generated from Type 1 font files and font subsetting
is possible.

-
Update Information:

This is most likely not exploitable on Fedora, due to FORTIFY_SOURCE protection
, as the overflow is strcat() call which is protected.

This update has a patch that avoids the call where the overflow would occur.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27767);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4033");
 
 name["english"] = "Fedora Core 7 2007-2343: t1lib";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the t1lib package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"t1lib-5.1.1-3.fc7", prefix:"t1lib-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"t1lib-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-4033", value:TRUE);
}
