#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2372 (openoffice.org).

OpenOffice.org is an Open Source, community-developed, multi-platform
office productivity suite.  It includes the key desktop applications,
such as a word processor, spreadsheet, presentation manager, formula
editor and drawing program, with a user interface and feature set
similar to other office suites.  Sophisticated and flexible,
OpenOffice.org also works transparently with a variety of file
formats, including Microsoft Office.

Usage: Simply type 'ooffice' to run OpenOffice.org or select the
requested component (Writer, Calc, Impress, etc.) from your
desktop menu. On first start a few files will be installed in the
user's home, if necessary.

-
Update Information:

This security updates addresses CVE-2007-2834 a flaw in
how openoffice.org handles corrupt TIFF graphic format file headers


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27771);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-0245", "CVE-2007-2834");
 
 name["english"] = "Fedora Core 7 2007-2372: openoffice.org";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openoffice.org package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"openoffice.org-2.2.1-18.2.fc7", prefix:"openoffice.org-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"openoffice.org-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-0245", value:TRUE);
 set_kb_item(name:"CVE-2007-2834", value:TRUE);
}
