#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2521 (libpng10).

The libpng10 package contains an old version of libpng, a library of functions
for creating and manipulating PNG (Portable Network Graphics) image format
files.

This package is needed if you want to run binaries that were linked dynamically
with libpng 1.0.x.

-
Update Information:

Certain chunk handlers in libpng10 before 1.0.29 allow remote attackers to caus
e a denial of service (crash) via crafted (1) pCAL (png_handle_pCAL), (2) sCAL
(png_handle_sCAL), (3) tEXt (png_push_read_tEXt), (4) iTXt (png_handle_iTXt), a
nd (5) ztXT (png_handle_ztXt) chunking in PNG images, which trigger out-of-boun
ds read operations.

[9]http://secunia.com/advisories/27093
[10]http://www.frsirt.com/english/advisories/2007/3390
[11]http://sourceforge.net/mailarchive/forum.php?thread_name=3.0.6.32.200710040
82318.012a7628%40mail.comcast.net&forum_name=png-mng-implement

This update to 1.0.29 addresses these issues.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27775);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-2445", "CVE-2007-5269");
 
 name["english"] = "Fedora Core 7 2007-2521: libpng10";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libpng10 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"libpng10-1.0.29-1.fc7", prefix:"libpng10-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"libpng10-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-2445", value:TRUE);
 set_kb_item(name:"CVE-2007-5269", value:TRUE);
}
