#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2635 (subversion).

Subversion is a concurrent version control system which enables one
or more users to collaborate in developing and maintaining a
hierarchy of files and directories while keeping a history of all
changes.  Subversion only stores the differences between versions,
instead of every complete file.  Subversion is intended to be a
compelling replacement for CVS.

-
Update Information:

This update includes the Subversion 1.4.4 release, including a number of bug fi
xes and a fix for a minor security issue.

An issue was discovered in the implementation of access control for revision pr
operties in the path-based authorization code.  In a repository using path-base
d access control, if a path was copied  from a private area to a public area, t
he revision properties of the (private) source path would become visible despit
e the access control restrictions.  (CVE-2007-2448)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27782);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-2448");
 
 name["english"] = "Fedora Core 7 2007-2635: subversion";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the subversion package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"subversion-1.4.4-1.fc7", prefix:"subversion-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"subversion-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-2448", value:TRUE);
}
