#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2649 (drupal).

Equipped with a powerful blend of features, Drupal is a Content Management
System written in PHP that can support a variety of websites ranging from
personal weblogs to large community-driven websites.  Drupal is highly
configurable, skinnable, and secure.

-
Update Information:

- Upgrade to 5.3, fixes:
- HTTP response splitting.
- Arbitrary code execution.
- Cross-site scripting.
- Cross-site request forgery.
- Access bypass.

Remember to log in to your site as the admin user before upgrading this package
.  After upgrading the package, browse to [9]http://host/drupal/update.php to r
un the upgrade script.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27783);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5593", "CVE-2007-5594", "CVE-2007-5595", "CVE-2007-5596", "CVE-2007-5597");
 
 name["english"] = "Fedora Core 7 2007-2649: drupal";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the drupal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"drupal-5.3-1.fc7", prefix:"drupal-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"drupal-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5593", value:TRUE);
 set_kb_item(name:"CVE-2007-5594", value:TRUE);
 set_kb_item(name:"CVE-2007-5595", value:TRUE);
 set_kb_item(name:"CVE-2007-5596", value:TRUE);
 set_kb_item(name:"CVE-2007-5597", value:TRUE);
}
