#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2686 (openvrml).

OpenVRML is a VRML/X3D support library, including a runtime and facilities
for reading and displaying VRML and X3D models.

-
ChangeLog:


Update information :

* Wed Oct 24 2007 Braden McDaniel  <braden endoframe com> - 0.16.6-3
- Updated firefox dependency to 2.0.0.8.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27792);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2007-2686: openvrml";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openvrml package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"openvrml-0.16.6-3.fc7", prefix:"openvrml-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
