#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2721 (xscreensaver).

A modular screen saver and locker for the X Window System.
More than 200 display modes are included in this package.

This is a metapackage for installing all default packages
related to XScreenSaver.

-
Update Information:

Related to bug 336331, another case is found which causes xscreensaver password
dialog crash. This time a patch from upstream developer is applied and this re
lease 'really' fixes this problem.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27798);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5585");
 
 name["english"] = "Fedora Core 7 2007-2721: xscreensaver";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xscreensaver package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"xscreensaver-5.03-14.fc7", prefix:"xscreensaver-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"xscreensaver-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5585", value:TRUE);
}
