#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2860 (zaptel).

Tools and libraries for using/configuring/monitoring Zapata telephony
interfaces.

-
Update Information:

Update to 1.4.6
Apply patch to fix CVE-2007-5690 / AST-2007-024.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28302);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5690");
 
 name["english"] = "Fedora Core 8 2007-2860: zaptel";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the zaptel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"zaptel-1.4.6-1.fc8", prefix:"zaptel-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"zaptel-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-5690", value:TRUE);
}
