#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-291 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

Update Information:

Updated to kernel 2.6.19.5 plus additional fixes:

[8]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.19.4
[9]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.19.5

CVE-2007-0772:
Summary: The Linux kernel before 2.6.20.1 allows remote
attackers to cause a denial of service (oops) via a crafted
NFSACL 2 ACCESS request that triggers a free of an incorrect
pointer.

CVE-2006-5753:
Summary: Unspecified vulnerability in the listxattr system
call in Linux kernel, when a 'bad inode' is present, allows
local users to cause a denial of service (data corruption)
and possibly gain privileges via unknown vectors.


Fixed broken SCSI CDROM IOCTLs.
Added Xen, which was missing from 1.2911.6.3



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24767);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5753", "CVE-2007-0772");
 
 name["english"] = "Fedora Core 6 2007-291: kernel";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"kernel-2.6.19-1.2911.6.4.fc6", prefix:"kernel-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kernel-", release:"FC6") )
{
 set_kb_item(name:"CVE-2006-5753", value:TRUE);
 set_kb_item(name:"CVE-2007-0772", value:TRUE);
}
