#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-2985 (arts).

arts (analog real-time synthesizer) is the sound system of KDE 3.

The principle of arts is to create/process sound using small modules which do
certain tasks. These may be create a waveform (oscillators), play samples,
filter data, add signals, perform effects like delay/flanger/chorus, or
output the data to the soundcard.

By connecting all those small modules together, you can perform complex
tasks like simulating a mixer, generating an instrument or things like
playing a wave file with some effects.

-
Update Information:

This is an update to the latest kde-3.5.8 release.  For more details, see
[9]http://kde.org/announcements/announce-3.5.8.php

This also addresses a security issue in kpdf, that can cause crashes or possibl
y execute arbitrary code, see
[10]http://www.kde.org/info/security/advisory-20071107-1.txt


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28186);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
 
 name["english"] = "Fedora Core 7 2007-2985: arts";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the arts package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"arts-1.5.8-4.fc7", prefix:"arts-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"arts-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-4352", value:TRUE);
 set_kb_item(name:"CVE-2007-5392", value:TRUE);
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
}
