#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3031 (xpdf).

Xpdf is an X Window System based viewer for Portable Document Format
(PDF) files. Xpdf is a small and efficient program which uses
standard X fonts.

-
Update Information:

Resolves:
xpdf memory corruption in DCTStream::readProgressiveDataUnit()
xpdf buffer overflow in DCTStream::reset()
xpdf buffer overflow in CCITTFaxStream::lookChar()


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28158);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
 
 name["english"] = "Fedora Core 7 2007-3031: xpdf";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xpdf package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"xpdf-3.02-4.fc7", prefix:"xpdf-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"xpdf-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-4352", value:TRUE);
 set_kb_item(name:"CVE-2007-5392", value:TRUE);
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
}
