#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3056 (emacs).

Emacs is a powerful, customizable, self-documenting, modeless text
editor. Emacs contains special code editing features, a scripting
language (elisp), and the capability to read mail, news, and more
without leaving the editor.

This package provides an emacs binary with support for X windows.

-
ChangeLog:


Update information :

* Tue Nov  6 2007 Chip Coldwell <coldwell redhat com> - 22.1-5
- fix insufficient safe-mode checks (Resolves: bz367581)
- Update rpm-spec-mode to the current upstream, drop compat patch (bz306841)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28255);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5795");
 
 name["english"] = "Fedora Core 7 2007-3056: emacs";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the emacs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"emacs-22.1-5.fc7", prefix:"emacs-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"emacs-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5795", value:TRUE);
}
