#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3093 (koffice).

KOffice - Integrated Office Suite
KOffice is a free, integrated office suite for KDE, the K Desktop Environment.

-
Update Information:

This update includes fixes to pdf import filters that can cause crashes possibl
y execute arbitrary code.  See
[9]http://www.kde.org/info/security/advisory-20071107-1.txt


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28161);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
 
 name["english"] = "Fedora Core 8 2007-3093: koffice";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the koffice package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"koffice-1.6.3-13.fc8", prefix:"koffice-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"koffice-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-4352", value:TRUE);
 set_kb_item(name:"CVE-2007-5392", value:TRUE);
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
}
