#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3253 (tomboy).

Tomboy is a desktop note-taking application for Linux and Unix. Simple and easy
to use, but with potential to help you organize the ideas and information you
deal with every day.  The key to Tomboy's usefulness lies in the ability to
relate notes and ideas together.  Using a WikiWiki-like linking system,
organizing ideas is as simple as typing a name.  Branching an idea off is easy
as pressing the Link button. And links between your ideas won't break, even whe
n
renaming and reorganizing them.

-
Update Information:

This update resolves a low severity security issue where LD_LIBRARY_PATH could
potentially get set to the current directory if it wasn't set before Tomboy was
launched.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28190);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2005-4790");
 
 name["english"] = "Fedora Core 8 2007-3253: tomboy";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tomboy package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"tomboy-0.8.1-3.fc8", prefix:"tomboy-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"tomboy-", release:"FC8") )
{
 set_kb_item(name:"CVE-2005-4790", value:TRUE);
}
