#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3308 (tetex).

TeTeX is an implementation of TeX for Linux or UNIX systems. TeX takes
a text file and a set of formatting commands as input and creates a
typesetter-independent .dvi (DeVice Independent) file as output.
Usually, TeX is used in conjunction with a higher level formatting
package like LaTeX or PlainTeX, since TeX by itself is not very
user-friendly. The output format needn't to be DVI, but also PDF,
when using pdflatex or similar tools.

Install tetex if you want to use the TeX text formatting system. Consider
to install tetex-latex (a higher level formatting package which provides
an easier-to-use interface for TeX). Unless you are an expert at using TeX,
you should also install the tetex-doc package, which includes the
documentation for TeX.

-
Update Information:

- fix t1lib flaw CVE-2007-4033 (#352271)
- fix CVE-2007-4352 CVE-2007-5392 CVE-2007-5393, various xpdf flaws (#345121)
- fix dvips -z buffer overflow with long href CVE-2007-5935 (#368591)
- fix insecure usage of temporary file in dviljk CVE-2007-5936 CVE-2007-5937 (#
368611, #368641)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28306);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3387", "CVE-2007-4033", "CVE-2007-5393", "CVE-2007-5935", "CVE-2007-5936", "CVE-2007-5937");
 
 name["english"] = "Fedora Core 8 2007-3308: tetex";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tetex package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"tetex-3.0-44.3.fc8", prefix:"tetex-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"tetex-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-3387", value:TRUE);
 set_kb_item(name:"CVE-2007-4033", value:TRUE);
 set_kb_item(name:"CVE-2007-5393", value:TRUE);
 set_kb_item(name:"CVE-2007-5935", value:TRUE);
 set_kb_item(name:"CVE-2007-5936", value:TRUE);
 set_kb_item(name:"CVE-2007-5937", value:TRUE);
}
