#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3369 (php-pear-MDB2).

PEAR::MDB2 is a merge of the PEAR::DB and Metabase php database abstraction
layers.

It provides a common API for all supported RDBMS. The main difference to most
other DB abstraction packages is that MDB2 goes much further to ensure
portability.

-
Update Information:

This update fixes a security flaw CVE-2007-5934 with critical impact. All users
of php-pear-MDB2 are strongly advised to upgrade to these updated packages.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28215);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5934");
 
 name["english"] = "Fedora Core 7 2007-3369: php-pear-MDB2";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php-pear-MDB2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"php-pear-MDB2-2.4.1-2.fc7", prefix:"php-pear-MDB2-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"php-pear-MDB2-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5934", value:TRUE);
}
