#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3414 (thunderbird).

Mozilla Thunderbird is a standalone mail and newsgroup client.

-
Update Information:

Updated thunderbird packages that fix several security bugs are now available f
or Fedora Core 8.

This update has been rated as having moderate security impact by the Fedora Sec
urity Response Team.

Mozilla Thunderbird is a standalone mail and newsgroup client.

Several flaws were found in the way in which Thunderbird processed certain malf
ormed HTML mail content. An HTML mail message containing malicious content coul
d cause Thunderbird to crash or potentially execute arbitrary code as the user
running Thunderbird. JavaScript support is disabled by default in Thunderbird;
these issues are not exploitable unless the user has enabled JavaScript. (CVE-2
007-5338, CVE-2007-5339, CVE-2007-5340)

Several flaws were found in the way in which Thunderbird displayed malformed HT
ML mail content. An HTML mail message containing specially-crafted content coul
d potentially trick a user into surrendering sensitive information. (CVE-2007-1
095, CVE-2007-3844, CVE-2007-3511, CVE-2007-5334)

A flaw was found in the Thunderbird sftp protocol handler. A malicious HTML mai
l message could access data from a remote sftp site, possibly stealing sensitiv
e user data. (CVE-2007-5337)

A request-splitting flaw was found in the way in which Thunderbird generates a
digest authentication request. If a user opened a specially-crafted URL, it was
possible to perform cross-site scripting attacks, web cache poisoning, or othe
r, similar exploits. (CVE-2007-2292)

Users of Thunderbird are advised to upgrade to these erratum packages, which co
ntain backported patches that correct these issues.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28230);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-2292", "CVE-2007-5334", "CVE-2007-5337", "CVE-2007-5340");
 
 name["english"] = "Fedora Core 8 2007-3414: thunderbird";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the thunderbird package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"thunderbird-2.0.0.9-1.fc8", prefix:"thunderbird-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"thunderbird-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-2292", value:TRUE);
 set_kb_item(name:"CVE-2007-5334", value:TRUE);
 set_kb_item(name:"CVE-2007-5337", value:TRUE);
 set_kb_item(name:"CVE-2007-5340", value:TRUE);
}
