#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3792 (blam).

Blam is a tool that helps you keep track of the growing
number of news feeds distributed as RSS. Blam lets you
subscribe to any number of feeds and provides an easy to
use and clean interface to stay up to date

-
Update Information:

This update resolves a low severity security issue where LD_LIBRARY_PATH could
potentially get set to the current directory if it wasn't set before Blam was l
aunched.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28342);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2005-4790");
 
 name["english"] = "Fedora Core 7 2007-3792: blam";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the blam package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"blam-1.8.3-9.fc7", prefix:"blam-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"blam-", release:"FC7") )
{
 set_kb_item(name:"CVE-2005-4790", value:TRUE);
}
