#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-3952 (gtkmozembedmm).

This package provides a C++/gtkmm wrapper for GtkMozEmbed
from Mozilla 1.4.x to 1.7.x.
The wrapper provides a convenient interface for C++ programmers
to use the Gtkmozembed HTML-rendering widget inside their software.

-
Update Information:

Updated firefox packages that fix several security issues are now available for
Fedora 7.

This update has been rated as having critical security impact by the Fedora Sec
urity Response Team.

Mozilla Firefox is an open source Web browser.

A cross-site scripting flaw was found in the way Firefox handled the jar: URI s
cheme. It was possible for a malicious website to leverage this flaw and conduc
t a cross-site scripting attack against a user running Firefox. (CVE-2007-5947)

Several flaws were found in the way Firefox processed certain malformed web con
tent. A webpage containing malicious content could cause Firefox to crash, or p
otentially execute arbitrary code as the user running Firefox. (CVE-2007-5959)

A race condition existed when Firefox set the 'window.location' property for a
webpage. This flaw could allow a webpage to set an arbitrary Referer header, wh
ich may lead to a Cross-site Request Forgery (CSRF) attack against websites tha
t rely only on the Referer header for protection. (CVE-2007-5960)

Users of Firefox are advised to upgrade to these updated packages, which contai
n backported patches to resolve these issues.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28345);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5947", "CVE-2007-5959", "CVE-2007-5960");
 
 name["english"] = "Fedora Core 7 2007-3952: gtkmozembedmm";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gtkmozembedmm package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"gtkmozembedmm-1.4.2.cvs20060817-14.fc7", prefix:"gtkmozembedmm-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"gtkmozembedmm-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5947", value:TRUE);
 set_kb_item(name:"CVE-2007-5959", value:TRUE);
 set_kb_item(name:"CVE-2007-5960", value:TRUE);
}
