#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-4263 (xorg-x11-xfs).

X.Org X11 xfs font server

-
References:

[ 1 ] Bug #373261 - CVE-2007-4568 xfs integer overflow in the build_range fun
ction [f7]
[9]https://bugzilla.redhat.com/show_bug.cgi?id=373261
[ 2 ] Bug #373331 - CVE-2007-4990 xfs heap overflow in the swap_char2b functi
on [f7]
[10]https://bugzilla.redhat.com/show_bug.cgi?id=373331


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29278);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4568", "CVE-2007-4990");
 
 name["english"] = "Fedora Core 7 2007-4263: xorg-x11-xfs";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xorg-x11-xfs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"xorg-x11-xfs-1.0.5-1.fc7", prefix:"xorg-x11-xfs-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"xorg-x11-xfs-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-4568", value:TRUE);
 set_kb_item(name:"CVE-2007-4990", value:TRUE);
}
