#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-4532 (autofs).

autofs is a daemon which automatically mounts filesystems when you use
them, and unmounts them later when you are not using them.  This can
include network filesystems, CD-ROMs, floppies, and so forth.

-
ChangeLog:


Update information :

* Thu Dec 13 2007 Ian Kent <ikent redhat com> - 5.0.2-20
- Bug 409701: CVE-2007-5964 Privilege Escalation (from local system) through /n
et autofs mount configuration bug
- use mount option 'nosuid' for '-hosts' map unless 'suid' is explicily speci
fied.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29715);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5964");
 
 name["english"] = "Fedora Core 8 2007-4532: autofs";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the autofs package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"autofs-5.0.2-20", prefix:"autofs-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"autofs-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-5964", value:TRUE);
}
